<?php
include 'conn.php'; // Include your database connection script

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $title = $_POST['title'];
    $main_photo = $_FILES['main_photo'];
    $photos = $_FILES['photos'];

    $target_dir = "uploads/";

    // Handle main photo upload
    $main_photo_path = $target_dir . basename($main_photo["name"]);
    if (!move_uploaded_file($main_photo["tmp_name"], $main_photo_path)) {
        echo "Sorry, there was an error uploading the main photo.";
        exit;
    }

    // Handle additional photos upload
    $photo_paths = [];
    for ($i = 0; $i < count($photos["name"]); $i++) {
        if ($photos["error"][$i] == UPLOAD_ERR_OK) {
            $photo_path = $target_dir . basename($photos["name"][$i]);
            if (move_uploaded_file($photos["tmp_name"][$i], $photo_path)) {
                $photo_paths[] = $photo_path;
            }
        }
    }

    // Pad photo paths to ensure exactly 10 entries
    for ($i = count($photo_paths); $i < 10; $i++) {
        $photo_paths[] = NULL;
    }

    // Prepare SQL statement
    $stmt = $conn->prepare("INSERT INTO gallery_Img (title, main_photo, photo1, photo2, photo3, photo4, photo5, photo6, photo7, photo8, photo9, photo10) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssssssssss", $title, $main_photo_path, $photo_paths[0], $photo_paths[1], $photo_paths[2], $photo_paths[3], $photo_paths[4], $photo_paths[5], $photo_paths[6], $photo_paths[7], $photo_paths[8], $photo_paths[9]);

    if ($stmt->execute()) {
        echo "New gallery created successfully";
    } else {
        echo "Error: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Admin Panal</title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="assets/img/favicon.png" rel="icon">
  <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">

</head>

<body>

  <!-- ======= Header ======= -->
   <?php include 'navbar.php' ?>
   <!-- End Header -->
   
   <!-- ======= Sidebar ======= -->
   <?php include 'sidebar.php' ?>
  <!-- End Sidebar-->

  <main id="main" class="main">
  <h2>Create Gallery</h2>
  <a style="margin-left:80%;margin-top:-60px;" class="btn btn-primary" href="gallery_view.php">View</a>

    <form action="" method="POST" enctype="multipart/form-data">
        <div>
            <label class="form-label" for="title">Title:</label><br>
            <input class="form-control" type="text" id="title" name="title" required><br><br>
        </div>
        <div>
            <label class="form-label" for="main_photo">Main Photo:</label><br>
            <input class="form-control" type="file" id="main_photo" name="main_photo" required><br><br>
        </div>
        <div>
            <label class="form-label" for="photos">Additional Photos (up to 10):</label><br>
            <input class="form-control" type="file" id="photos" name="photos[]" multiple><br><br>
        </div>
        <button class="btn btn-primary" type="submit">Create Gallery</button>
    </form>

  </main>
  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

<!-- Vendor JS Files -->
<script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/vendor/chart.js/chart.umd.js"></script>
<script src="assets/vendor/echarts/echarts.min.js"></script>
<script src="assets/vendor/quill/quill.min.js"></script>
<script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
<script src="assets/vendor/tinymce/tinymce.min.js"></script>
<script src="assets/vendor/php-email-form/validate.js"></script>

<!-- Template Main JS File -->
<script src="assets/js/main.js"></script>

</body>

</html>