<?php
$conn = new mysqli("localhost", "root", "", "fkr");

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Validate and sanitize student_id
$student_id = isset($_GET['v_id']) ? (int) $_GET['v_id'] : 0;

// Prepare query to prevent SQL injection
$stmt = $conn->prepare("SELECT * FROM fee_receipts WHERE id = ?");
$stmt->bind_param("i", $student_id);
$stmt->execute();
$result = $stmt->get_result();
$fee = $result->fetch_assoc();


// Assign variables from database
$date = $fee['date'];
$Month = $fee['Month'];
$student_name = $fee['student_name'];
$father_name = $fee['father_name'];
$class = $fee['class'];
$receipt_no = $fee['receipt_no'];
$monthly_fee = $fee['monthly_fee'];
$admission_fee = $fee['admission_fee'];
$exam_fee = $fee['exam_fee'];
$dues = $fee['dues'];
$other_fee = $fee['other_fee'];
$total = $fee['total'];

// Load FPDF
require('fpdf186/fpdf.php');

$pdf = new FPDF('P', 'mm', array(80, 150)); // Small receipt size
$pdf->AddPage();

$pdf->SetFont('Arial', 'B', 10);

// Header with logo
$pdf->Image('logo.png', 10, 5, 20);
$pdf->Cell(0, 6, 'THE CITY ISLAMIC SCHOOL', 0, 1, 'C');
$pdf->SetFont('Arial', '', 8);
$pdf->Cell(0, 4, 'TANDO ALLAHYAR', 0, 1, 'C');
$pdf->Cell(0, 4, '0300-3280359 | 0304-7955740', 0, 1, 'C');

$pdf->SetFont('Arial', 'B', 9);
$pdf->Cell(0, 6, 'FEE RECEIPT', 0, 1, 'C');

// Student Info
$pdf->SetFont('Arial', '', 8);
$pdf->Ln(2);
$pdf->Cell(0, 4, "Date: $date", 0, 1, 'C');
$pdf->Cell(0, 4, "Month: $Month", 0, 1, 'C');
$pdf->Cell(0, 4, "Name: $student_name", 0, 1, 'C');
$pdf->Cell(0, 4, "Father: $father_name", 0, 1, 'C');
$pdf->Cell(0, 4, "Class: $class", 0, 1, 'C');
$pdf->Cell(0, 4, "GR No: $receipt_no", 0, 1, 'C');

$pdf->Ln(1);

// Fee Details
$pdf->Cell(0, 4, "Monthly Fee: Rs. $monthly_fee", 0, 1, 'C');
$pdf->Cell(0, 4, "Admission Fee: Rs. $admission_fee", 0, 1, 'C');
$pdf->Cell(0, 4, "Exam Fee: Rs. $exam_fee", 0, 1, 'C');
$pdf->Cell(0, 4, "Dues: Rs. $dues", 0, 1, 'C');
$pdf->Cell(0, 4, "Other Charges: Rs. $other_fee", 0, 1, 'C');

// Total
$pdf->SetFont('Arial', 'B', 9);
$pdf->Ln(1);
$pdf->Cell(0, 6, "TOTAL: Rs. $total", 1, 1, 'C');

// Footer
$pdf->Ln(4);
$pdf->SetFont('Arial', '', 8);
$pdf->Cell(0, 4, "RS/- __________ only", 0, 1, 'C');
$pdf->Cell(0, 4, "Signature: __________________", 0, 1, 'C');

// Output
$pdf->Output();
?>
