<?php
include 'conn.php';
include('fpdf186/fpdf.php'); // Make sure you have FPDF library


if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $gr_no = $_POST['gr_no'];
    $student_name = $_POST['student_name'];
    $father_name = $_POST['father_name'];
    $place_of_birth = $_POST['place_of_birth'];
    $dob_figure = $_POST['dob_figure'];
    $dob_words = $_POST['dob_words'];
    $cast = $_POST['cast'];
    $religion = $_POST['religion'];
    $last_school = $_POST['last_school'];
    $class_admit = $_POST['class_admit'];
    $date_of_admission = $_POST['date_of_admission'];
    $gr_no_slc = $_POST['gr_no_slc'];
    $current_class = $_POST['current_class'];
    $leaving_reason = $_POST['leaving_reason'];
    $remarks = $_POST['remarks'];

    $stmt = $conn->prepare("INSERT INTO school_leaving_form (gr_no, student_name, father_name, place_of_birth, dob_figure, dob_words, cast, religion, last_school, class_admit, date_of_admission, gr_no_slc, current_class, leaving_reason, remarks, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())");

    if ($stmt) {
        $stmt->bind_param("sssssssssssssss", 
            $gr_no, $student_name, $father_name, $place_of_birth, $dob_figure, $dob_words, $cast, $religion, $last_school, $class_admit, $date_of_admission, $gr_no_slc, $current_class, $leaving_reason, $remarks
        );

       if ($stmt->execute()) {
    $pdf = new FPDF();
    $pdf->AddPage();
$pdf->Image('logow.png', 35, 60, 140); 

    // Set Title Font
    $pdf->SetFont('Arial', 'B', 18);
    $pdf->Image('logo.png', 10, 10, 30); // Logo (adjust path if needed)
    $pdf->Cell(0, 10, '', 0, 1); // Spacer
    $pdf->Ln(5);

    // Heading
    $pdf->Cell(0, 10, 'THE CITY ISLAMIC SCHOOL', 0, 1, 'C');
    $pdf->SetFont('Arial', 'B', 16);
    $pdf->Cell(0, 10, 'SCHOOL LEAVING CERTIFICATE', 0, 1, 'C');
    $pdf->Ln(5);
    $pdf->SetFont('Arial', '', 12);
    $pdf->Cell(0, 0, '', 'T'); // Thin line

    // Section: Student Info
    $pdf->Ln(10);
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->Cell(0, 10, 'Student Information', 0, 1, 'L');
    $pdf->SetFont('Arial', '', 12);
    $pdf->Cell(95, 10, 'G.R No: ' . $gr_no, 1, 0);
    $pdf->Cell(95, 10, 'Previous G.R No: ' . $gr_no_slc, 1, 1);
    $pdf->Cell(95, 10, 'Student Name: ' . $student_name, 1, 0);
    $pdf->Cell(95, 10, 'Father Name: ' . $father_name, 1, 1);
    $pdf->Cell(95, 10, 'Place of Birth: ' . $place_of_birth, 1, 0);
    $pdf->Cell(95, 10, 'DOB (Figures): ' . $dob_figure, 1, 1);
    $pdf->Cell(0, 10, 'DOB (Words): ' . $dob_words, 1, 1);
    $pdf->Cell(95, 10, 'Cast: ' . $cast, 1, 0);
    $pdf->Cell(95, 10, 'Religion: ' . $religion, 1, 1);

    // Section: Admission
    $pdf->Ln(5);
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->Cell(0, 10, 'Admission Details', 0, 1, 'L');
    $pdf->SetFont('Arial', '', 12);
    $pdf->Cell(0, 10, 'Came From: ' . $last_school, 1, 1);
    $pdf->Cell(95, 10, 'Class Admitted: ' . $class_admit, 1, 0);
    $pdf->Cell(95, 10, 'Date of Admission: ' . $date_of_admission, 1, 1);
    $pdf->Cell(0, 10, 'Studying in Class: ' . $current_class, 1, 1);

    // Section: Leaving
    $pdf->Ln(5);
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->Cell(0, 10, 'Leaving Information', 0, 1, 'L');
    $pdf->SetFont('Arial', '', 12);
    $pdf->Cell(0, 10, 'Reason of Leaving: ' . $leaving_reason, 1, 1);
    $pdf->Cell(0, 10, 'Remarks: ' . $remarks, 1, 1);

    // Footer Signatures
    $pdf->Ln(20);
    $pdf->Cell(95, 10, 'Signature of Guardian', 0, 0, 'L');
    $pdf->Cell(95, 10, 'Signature of Principal', 0, 1, 'R');

    $pdf->Output();
    exit;
}


        $stmt->close();
    } else {
        echo "<script>alert('Prepare failed: " . $conn->error . "');</script>";
    }
}
?>



<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Admin Panal</title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="assets/img/favicon.png" rel="icon">
  <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">

  <!-- =======================================================
  * Template Name: NiceAdmin
  * Updated: Jan 29 2024 with Bootstrap v5.3.2
  * Template URL: https://bootstrapmade.com/nice-admin-bootstrap-admin-html-template/
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
</head>

<body>

  <!-- ======= Header ======= -->
   <?php include 'navbar.php' ?>
   <!-- End Header -->
   
   <!-- ======= Sidebar ======= -->
   <?php include 'sidebar.php' ?>
  <!-- End Sidebar-->

  <main id="main" class="main">
    <h2>School Leaving Certificate Form</h2>
    <a style="margin-left:80%;margin-top:-60px;" class="btn btn-primary" href="certificate_view.php">View</a>
    <form method="POST" action="" enctype="multipart/form-data" class="row g-3">
    <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">G.R No</label>
                <input type="text" name="gr_no" class="form-control" required>
            </div>
            <div class="col-md-6">
                <label class="form-label">Student Name</label>
                <input type="text" name="student_name" class="form-control" required>
            </div>
            <div class="col-md-6">
                <label class="form-label">Father Name</label>
                <input type="text" name="father_name" class="form-control" required>
            </div>
            <div class="col-md-6">
                <label class="form-label">Place of Birth</label>
                <input type="text" name="place_of_birth" class="form-control">
            </div>
            <div class="col-md-6">
                <label class="form-label">Date of Birth (Figures)</label>
                <input type="text" name="dob_figure" class="form-control" placeholder="e.g. 01-01-2000">
            </div>
            <div class="col-md-6">
                <label class="form-label">Date of Birth (Words)</label>
                <input type="text" name="dob_words" class="form-control" placeholder="e.g. First January Two Thousand">
            </div>
            <div class="col-md-6">
                <label class="form-label">Cast</label>
                <input type="text" name="cast" class="form-control">
            </div>
            <div class="col-md-6">
                <label class="form-label">Religion</label>
                <input type="text" name="religion" class="form-control">
            </div>
            <div class="col-md-6">
                <label class="form-label">From Which School Come</label>
                <input type="text" name="last_school" class="form-control">
            </div>
            <div class="col-md-6">
                <label class="form-label">In Which Class Admitted</label>
                <input type="text" name="class_admit" class="form-control">
            </div>
            <div class="col-md-6">
                <label class="form-label">Date of Admission</label>
                <input type="date" name="date_of_admission" class="form-control">
            </div>
            <div class="col-md-6">
                <label class="form-label">G.R No (from previous school)</label>
                <input type="text" name="gr_no_slc" class="form-control">
            </div>
            <div class="col-md-6">
                <label class="form-label">Current Class (At time of leaving)</label>
                <input type="text" name="current_class" class="form-control">
            </div>
            <div class="col-md-6">
                <label class="form-label">Reason of School Leaving</label>
                <input type="text" name="leaving_reason" class="form-control">
            </div>
            <div class="col-md-12">
                <label class="form-label">Remarks</label>
                <textarea name="remarks" class="form-control"></textarea>
            </div>
        </div>
    
    <div class="text-center">
        <button type="submit" class="btn btn-primary">Submit</button>
    </div>
</form>

              
  </main><!-- End #main -->

<!-- ======= Footer ======= -->
<!-- <footer id="footer" class="footer">
  <div class="copyright">
    &copy; Copyright <strong><span>NiceAdmin</span></strong>. All Rights Reserved
  </div>
  <div class="credits">
   
     Purchase the pro version with working PHP/AJAX contact form: https://bootstrapmade.com/nice-admin-bootstrap-admin-html-template/ 
    Designed by <a href="https://bootstrapmade.com/">BootstrapMade</a>
  </div>
</footer>End Footer -->

<a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

<!-- Vendor JS Files -->
<script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/vendor/chart.js/chart.umd.js"></script>
<script src="assets/vendor/echarts/echarts.min.js"></script>
<script src="assets/vendor/quill/quill.min.js"></script>
<script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
<script src="assets/vendor/tinymce/tinymce.min.js"></script>
<script src="assets/vendor/php-email-form/validate.js"></script>

<!-- Template Main JS File -->
<script src="assets/js/main.js"></script>

</body>

</html>