<?php
include 'conn.php';
include('fpdf186/fpdf.php'); // Make sure you have FPDF library

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $gr_no = $conn->real_escape_string($_POST['gr_no']);
    $student_name = $conn->real_escape_string($_POST['student_name']);
    $father_name = $conn->real_escape_string($_POST['father_name']);
    $place_of_birth = $conn->real_escape_string($_POST['place_of_birth']);
    $date_of_birth = $conn->real_escape_string($_POST['date_of_birth']);
    $date_of_birth_in_words = $conn->real_escape_string($_POST['date_of_birth_in_words']);
    $cast = $conn->real_escape_string($_POST['cast']);
    $religion = $conn->real_escape_string($_POST['religion']);
    $last_school = $conn->real_escape_string($_POST['last_school']);
    $class_admit = $conn->real_escape_string($_POST['class_admit']);
    $date_of_admission = $conn->real_escape_string($_POST['date_of_admission']);
    $mailing_address = $conn->real_escape_string($_POST['mailing_address']);
    $student_b_form = $conn->real_escape_string($_POST['student_b_form']);
    $g_cnic_no = $conn->real_escape_string($_POST['g_cnic_no']);
    $g_name = $conn->real_escape_string($_POST['g_name']);
    $mobail_no = $conn->real_escape_string($_POST['mobail_no']);
    $w_no = $conn->real_escape_string($_POST['w_no']);
    
    

        
        // Use prepared statements to avoid SQL injection
        $stmt = $conn->prepare("INSERT INTO `freeshipstudent` 
(aid, gr_no, student_name, father_name, place_of_birth, date_of_birth, date_of_birth_in_words, cast, religion, last_school, class_admit, date_of_admission, mailing_address, student_b_form, g_cnic_no, g_name, mobail_no, w_no, crated_at) 
VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())");

if ($stmt) {
    $stmt->bind_param("ssssssssssssssssss", 
        $aid, $gr_no, $student_name, $father_name, $place_of_birth, $date_of_birth, 
        $date_of_birth_in_words, $cast, $religion, $last_school, $class_admit, 
        $date_of_admission, $mailing_address, $student_b_form, $g_cnic_no, 
        $g_name, $mobail_no, $w_no
    );

   if ($stmt->execute()) {

        // ✅ Generate PDF
       

$pdf = new FPDF();
$pdf->AddPage();
// $pdf->SetLineWidth(1);
// $pdf->Rect(10, 10, 190, 277); // (x, y, width, height)
$pdf->Image('logow.png', 35, 60, 140); 

$pdf->Image('logo.png', 10, 10, 30); // (file, x, y, width)

// Leave space for logo
$pdf->SetXY(10, 10); // Move cursor after logo
// Set fonts and header
$pdf->SetFont('Arial', 'B', 16);
$pdf->Cell(0, 10, 'THE CITY ISLAMIC SCHOOL', 0, 1, 'C');

$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 10, 'TANDO ALLAH YAR', 0, 1, 'C');

$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 10, 'ADMISSION FORM', 0, 1, 'C');

$pdf->Ln(5); // Line break

// GR No and Date
$pdf->SetFont('Arial', '', 12);
$pdf->Cell(95, 10, 'G.R. No: ' . $gr_no, 1, 0);
$pdf->Cell(95, 10, 'Date: ' . date("d-m-Y"), 1, 1);

// STUDENT PROFILE
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, "STUDENT'S PROFILE", 0, 1);

$pdf->SetFont('Arial', '', 12);
$pdf->Cell(95, 10, "Name of Student: $student_name", 1, 0);
$pdf->Cell(95, 10, "Father's Name: $father_name", 1, 1);

$pdf->Cell(95, 10, "Place of Birth: $place_of_birth", 1, 0);
$pdf->Cell(95, 10, "Date of Birth: $date_of_birth", 1, 1);
$pdf->Cell(0, 10, "DOB (in Words): $date_of_birth_in_words", 1, 0);

$pdf->Cell(0, 10, "", 1, 1);
$pdf->Cell(95, 10, "Surname: $cast", 1, 0);
$pdf->Cell(0, 10, "Religion: $religion", 1, 1);
// $pdf->Cell(95, 10, "Surname: $cast", 1, 1);
$pdf->Cell(0, 10, "Mailing Address: $mailing_address", 1, 1);
$pdf->Ln(5); // Line break

// FOR OFFICE USE
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, "FOR OFFICE USE ONLY", 0, 1);

$pdf->SetFont('Arial', '', 12);
$pdf->Cell(0, 10, "Last School Attended: $last_school", 1, 1);
$pdf->Cell(95, 10, "Date of Admission: $date_of_admission", 1, 0);
$pdf->Cell(95, 10, "Class Admitted: $class_admit", 1, 1);

$pdf->Cell(0, 10, "Student's B Form #: $student_b_form", 1, 1);
$pdf->Cell(0, 10, "Guardian Name: $g_name", 1, 1);
$pdf->Cell(0, 10, "Guardian's CNIC: $g_cnic_no", 1, 1);

// Phone Numbers
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, "IMPORTANT PHONE NUMBERS", 0, 1);
$pdf->SetFont('Arial', '', 12);
$pdf->Cell(95, 10, "Mobile #: $mobail_no", 1, 0);
$pdf->Cell(95, 10, "WhatsApp #: $w_no", 1, 1);

// Rules
$pdf->Ln(5);
$pdf->Cell(0, 10, "I will obey all the rules and regulations of the school", 0, 1);

// Documents Received
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, "DOCUMENTS RECEIVED", 0, 1);

$pdf->SetFont('Arial', '', 12);
$pdf->Cell(63, 10, "B Form / Birth Certificate", 1, 0);
$pdf->Cell(63, 10, "School Leaving Certificate", 1, 0);
$pdf->Cell(64, 10, "Guardian CNIC Copy", 1, 1);

// Signatures
$pdf->Ln(10);
$pdf->Cell(95, 10, "Parent's Signature", 0, 0, 'L');
$pdf->Cell(95, 10, "Principal's Signature", 0, 1, 'R');

// Show PDF
$pdf->Output();


    } else {
        echo "<script>alert('Error: " . $stmt->error . "');</script>";
    }

    $stmt->close();
} else {
    echo "<script>alert('Prepare failed: " . $conn->error . "');</script>";
}}
?>


<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Admin Panal</title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="assets/img/favicon.png" rel="icon">
  <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">

  <!-- =======================================================
  * Template Name: NiceAdmin
  * Updated: Jan 29 2024 with Bootstrap v5.3.2
  * Template URL: https://bootstrapmade.com/nice-admin-bootstrap-admin-html-template/
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
</head>

<body>

  <!-- ======= Header ======= -->
   <?php include 'navbar.php' ?>
   <!-- End Header -->
   
   <!-- ======= Sidebar ======= -->
   <?php include 'sidebar.php' ?>
  <!-- End Sidebar-->

  <main id="main" class="main">
    <h2>Admission Form</h2>
    <a style="margin-left:80%;margin-top:-60px;" class="btn btn-primary" href="freestview.php">View</a>
    <form method="POST" action="" enctype="multipart/form-data" class="row g-3">
    <div class="col-md-6">
        <label for="inputName5" class="form-label">GR No</label>
        <input type="number" name="gr_no" class="form-control" id="inputName5">
    </div>
    <div class="col-md-6">
        <label for="inputName5" class="form-label">Student Name</label>
        <input type="text" name="student_name" class="form-control" id="inputName5">
    </div>
    <div class="col-md-6">
        <label for="inputName5" class="form-label">Father Name</label>
        <input type="text" name="father_name" class="form-control" id="inputName5">
    </div>
    <div class="col-md-6">
        <label for="inputName5" class="form-label">Place Of Birth</label>
        <input type="text" name="place_of_birth" class="form-control" id="inputName5">
    </div>
    <div class="col-md-6">
        <label for="inputName5" class="form-label">Date Of Birth</label>
        <input type="date" name="date_of_birth" class="form-control" id="inputName5">
    </div>
    <div class="col-md-6">
        <label for="inputName5" class="form-label">Date Of Birth in Words</label>
        <input type="text" name="date_of_birth_in_words" class="form-control" id="inputName5">
    </div>
    <div class="col-md-6">
        <label for="inputName5" class="form-label">Cast</label>
        <input type="text" name="cast" class="form-control" id="inputName5">
    </div>
    <div class="col-md-6">
        <label for="inputName5" class="form-label">Religion</label>
        <input type="text" name="religion" class="form-control" id="inputName5">
    </div>
    <div class="col-md-6">
        <label for="inputName5" class="form-label">Last School</label>
        <input type="text" name="last_school" class="form-control" id="inputName5">
    </div>
    <div class="col-md-6">
        <label for="inputName5" class="form-label">Which Class Admission</label>
        <input type="text" name="class_admit" class="form-control" id="inputName5">
    </div>
    <div class="col-md-6">
        <label for="inputName5" class="form-label">Date Of Admission</label>
        <input type="date" name="date_of_admission" class="form-control" id="inputName5">
    </div>
    <div class="col-md-6">
        <label for="inputName5" class="form-label">Student B Form No</label>
        <input type="text" name="student_b_form" class="form-control" id="inputName5">
    </div>
    <div class="col-md-6">
        <label for="inputName5" class="form-label">Guardian Name</label>
        <input type="text" name="g_name" class="form-control" id="inputName5">
    </div>
    <div class="col-md-6">
        <label for="inputName5" class="form-label">Guardian CNIC</label>
        <input type="text" name="g_cnic_no" class="form-control" id="inputName5">
    </div>
    <div class="col-md-6">
        <label for="inputName5" class="form-label">Mobail No</label>
        <input type="number" name="mobail_no" class="form-control" id="inputName5">
    </div>
     <div class="col-md-6">
        <label for="inputName5" class="form-label">WhatsApp No</label>
        <input type="number" name="w_no" class="form-control" id="inputName5">
    </div>
    <div class="col-md-12">
        <label for="inputEmail5" class="form-label">Mailing Address</label>
        <textarea name="mailing_address" class="form-control" id=""></textarea>
    </div>
    
    <div class="text-center">
        <button type="submit" class="btn btn-primary">Submit</button>
    </div>
</form>

              
  </main><!-- End #main -->

<!-- ======= Footer ======= -->
<!-- <footer id="footer" class="footer">
  <div class="copyright">
    &copy; Copyright <strong><span>NiceAdmin</span></strong>. All Rights Reserved
  </div>
  <div class="credits">
   
     Purchase the pro version with working PHP/AJAX contact form: https://bootstrapmade.com/nice-admin-bootstrap-admin-html-template/ 
    Designed by <a href="https://bootstrapmade.com/">BootstrapMade</a>
  </div>
</footer>End Footer -->

<a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

<!-- Vendor JS Files -->
<script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/vendor/chart.js/chart.umd.js"></script>
<script src="assets/vendor/echarts/echarts.min.js"></script>
<script src="assets/vendor/quill/quill.min.js"></script>
<script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
<script src="assets/vendor/tinymce/tinymce.min.js"></script>
<script src="assets/vendor/php-email-form/validate.js"></script>

<!-- Template Main JS File -->
<script src="assets/js/main.js"></script>

</body>

</html>