


<?php
include 'conn.php';

// Set the number of records to display per page
$records_per_page = 10;

// Get the current page number from the query string, default is 1
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;

// Calculate the offset for the SQL query
$offset = ($page - 1) * $records_per_page;

// Prepare search values
$search_gr_no = isset($_GET['gr_no']) ? $_GET['gr_no'] : '';
$search_name = isset($_GET['student_name']) ? $_GET['student_name'] : '';

// Build base query with filters
$where = "WHERE 1=1";
$params = [];
$types = "";

if (!empty($search_gr_no)) {
    $where .= " AND gr_no LIKE ?";
    $params[] = "%$search_gr_no%";
    $types .= "s";
}

if (!empty($search_name)) {
    $where .= " AND student_name LIKE ?";
    $params[] = "%$search_name%";
    $types .= "s";
}

// Get total count
$stmt_count = $conn->prepare("SELECT COUNT(*) AS total FROM employees $where");
if (!empty($params)) {
    $stmt_count->bind_param($types, ...$params);
}
$stmt_count->execute();
$total_result = $stmt_count->get_result();
$total_records = $total_result->fetch_assoc()['total'];
$total_pages = ceil($total_records / $records_per_page);
$stmt_count->close();

// Fetch paginated records
$query = "SELECT * FROM employees $where LIMIT $offset, $records_per_page";
$stmt = $conn->prepare($query);
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Admin Panel</title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="assets/img/favicon.png" rel="icon">
  <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">

  <!-- DataTables CSS Files -->
  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.css">

  <!-- =======================================================
  * Template Name: NiceAdmin
  * Updated: Jan 29 2024 with Bootstrap v5.3.2
  * Template URL: https://bootstrapmade.com/nice-admin-bootstrap-admin-html-template/
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
</head>

<body>

  <!-- ======= Header ======= -->
  <?php include 'navbar.php';  ?>
  <!-- End Header -->
   
  <!-- ======= Sidebar ======= -->
  <?php include 'sidebar.php'; ?>
  <!-- End Sidebar-->

  <main id="main" class="main">
    <div class="card">
      <div class="card-body">
        <h5 class="card-title">Teacher Records</h5>
    <a style="margin-left:80%;margin-top:-60px;" class="btn btn-primary" href="techer.php">Add New</a>

<!-- Search Form -->


<!-- Export & Print Buttons -->

        <table id="newsTable" class="table display">
          <thead>
            <tr>
              <th scope="col">Name</th>
              <th scope="col">Father/Husband</th>
              <th scope="col">Date of Appointment</th>
              <th scope="col">Subjects</th>
              <th scope="col">Status</th>
              <th scope="col">Action</th>
            </tr>
          </thead>
          <tbody>
            <?php
              if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
            ?>
            <tr>
              <td><?= $row['employee_name'] ?></td>
              <td><?= $row['father_or_husband_name'] ?></td>
              <td><?= $row['date_of_appointment'] ?></td>
              <td><?= $row['teaching_subjects'] ?></td>
              <td><?= $row['status'] ?></td>    
              <td><a  href="techE.php?e_id=<?php echo $row['id']?>"><i class="bi bi-pencil-square"></i></a>&nbsp;&nbsp;&nbsp;<a   href="delete.php?techd_id=<?php echo $row['id']?>"><i class="bi bi-trash3"></i></a></td>

            </tr>
            <?php
                }
              } else {
            ?>
            <tr>
              <td colspan="5">No records found</td>
            </tr>
            <?php
              }
            ?>
          </tbody>
        </table>
        <!-- End Active Table -->

        <!-- Pagination -->
        <nav aria-label="Page navigation example">
          <ul class="pagination">
            <li class="page-item<?= ($page <= 1) ? ' disabled' : '' ?>">
              <a class="page-link" href="?page=<?= $page - 1 ?>" aria-label="Previous">
                <span aria-hidden="true">&laquo;</span>
              </a>
            </li>
            <?php for ($i = 1; $i <= $total_pages; $i++) { ?>
              <li class="page-item<?= ($i == $page) ? ' active' : '' ?>"><a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a></li>
            <?php } ?>
            <li class="page-item<?= ($page >= $total_pages) ? ' disabled' : '' ?>">
              <a class="page-link" href="?page=<?= $page + 1 ?>" aria-label="Next">
                <span aria-hidden="true">&raquo;</span>
              </a>
            </li>
          </ul>
        </nav>
        <!-- End Pagination -->
      </div>
    </div>
  </main>
  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.min.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- DataTables JS Files -->
  <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>

  <!-- DataTables Initialization -->
  <script>
    $(document).ready(function() {
        $('#newsTable').DataTable({
            "paging": false, // Disable DataTables paging since we handle it on server-side
            "searching": true, // Enable searching
            "ordering": true // Enable column ordering
        });
    });
  </script>

</body>

</html>

