<!DOCTYPE html>
<!--[if (gte IE 9)|!(IE)]><!-->
<html lang="en">
<!--<![endif]-->

<head>
    <title>Rozedhani Community Organization</title>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="" />
    <meta name="keywords" content="" />
    <meta name="author" content="" />
    <meta name="title" content="" />
    <link type="image/x-icon" href="assets/images/logo/logo.png" rel="icon">
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800%7CRoboto+Slab:300,400,700"
        rel="stylesheet">
    <link rel="stylesheet" href="css/font-awesome.min.css">
    <link href="css/bootstrap.min.css" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" href="css/danveer.css">
    <link rel="stylesheet" type="text/css" href="css/custam.css">
    <link rel="stylesheet" type="text/css"
        href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css" />
    <link rel="stylesheet" type="text/css"
        href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css" />
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-142494086-2"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag() { dataLayer.push(arguments); }
        gtag('js', new Date());

        gtag('config', 'UA-142494086-2');
    </script>
</head>

<body>
    <!-- START PRELOADER -->
    <div id="preloader">
        <div id="spinner">
            <img src="image/tab-icon.png" alt="loader" class="loading">
            <h5 class="line-height-50 font-18">Loading...</h5>
        </div>
    </div>
    <!-- END PRELOADER -->

    <!-- HEADER START -->
    <?php include 'header.php' ?>

    <!-- HEADER END -->

    <!-- MAIN START -->
    <main class="main">
        <div class="aboutus-banner text-left">
            <div class="banner-content">
                <div class="container pl-0">
                    <h1 class="heading-three">About Us</h1>
                </div>
            </div>
        </div>
        
        <div class="about-part">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 col-sm-12 col-xs-12 col-lg-6 order-md-2 order-lg-1">
                        <img src="assets/images/logo/logo.png" alt="about-img" width="400px" height="440px">
                    </div>
                    <div class="col-md-12 col-sm-12 col-xs-12 col-lg-6 about-detail order-md-1 order-lg-1">
                        <h2 class="section-title">WHY RDCO?</h2>
                        <p class="section-detail">
                            RDCO is driven by a profound mission to make a transformative impact in Achro Thar Taluka
                            Khipro, District Sanghar. We believe Compassion, Integrity, Excellence, Collaboration,
                            Innovation, Diversity, Accountability, Empowerment, Respect, and Sustainability, guiding our
                            efforts to achieve our goals, we strive to address critical challenges, aiming to create
                            sustainable change and improve the lives of poor communities. Our dedication to RDCO's
                            mission is reflected in our commitment to transparency, accountability, and collaboration
                            with stakeholders. Together with our supporters and partners, we envision a future where,
                            making a lasting difference in Achro Thar.
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="service-part">
            <div class="container">
                <div class="row" id="counter">
                    <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12 service-info">
                        <div class="img-box float-sm-left mr-2">
                            <img src="image/feed-donation-icon.png" alt="donation-icon">
                        </div>
                        <div class="service-detail float-sm-left mr-3">
                            <h5 class="head-five">Donation</h5>
                            <span class="service-span" data-count="13790">0</span>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12 service-info">
                        <div class="img-box float-sm-left mr-2">
                            <img src="image/feed-volunteer-icon.png" alt="volunteer-icon">
                        </div>
                        <div class="service-detail float-sm-left">
                            <h5 class="head-five">Volunteer Reached</h5>
                            <span class="service-span" data-count="1560">0</span>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12 service-info">
                        <div class="img-box float-sm-left mr-2">
                            <img src="image/feed-success-icon.png" alt="success-icon">
                        </div>
                        <div class="service-detail float-sm-left">
                            <h5 class="head-five">Success Mission</h5>
                            <span class="service-span" data-count="809">0</span>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12 service-info">
                        <div class="img-box float-sm-left mr-2">
                            <img src="image/feed-globalization-icon.png" alt="globalization-icon">
                        </div>
                        <div class="service-detail float-sm-left">
                            <h5 class="head-five">Globalization</h5>
                            <span class="service-span" data-count="1025">0</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="about-service paddingub text-center intro">
            <div class="container">
                <div class="causes-content text-center">
                    <h2 class="section-title">Complited Projects</h2>
                    <p class="section-detail">At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis
                        praesentium voluptatum deleniti atque<br>corrupti quos dolores et quas molestias excepturi sint
                        occaecati cupiditate non provident,</p>
                </div>
                <div class="row">
                <?php
$sql = "SELECT title, no_p FROM project";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
  while($row = $result->fetch_assoc()) {
?>
                    <div class="col-xs-12 col-sm-6 col-md-3">
                        <div class="about-serv-detail">
                            <img src="image/adoption-icon.png" alt="health-icon" class="mb-3 animall">
                            <h4 class="ser-title"><?php echo htmlspecialchars($row['title'])?></h4>
                            <h3 class="section-title"><?php echo htmlspecialchars($row['no_p'])?>+</h3>
                        </div>
                    </div>
                    <?php }}?>
                    
                </div>
            </div>
        </div>

      

        <div class="team-slider intro">
            <div class="container">
                <div class="causes-content text-center my-5">
                    <h2 class="section-title" style="color: #fff;">Board of Directors</h2>
                    <p class="section-detail" style="color: #fff; width: 60%; margin: auto;">Our Board of Directors
                        provides strategic leadership and oversight to RDCO, guiding our mission and ensuring
                        accountability. Comprised of accomplished professionals from diverse backgrounds, our board
                        members bring extensive expertise in social sector. They are dedicated to upholding our values,
                        fostering innovation, and driving sustainable growth</p>
                </div>
                <div class="slider">
                    <div class="sipper">
                        <div class="card-wrapper-data">
                            <div class="profile-wrapper">
                                <img src="assets/images/Board of Directors/Abdul Aziz Halepoto.jfif" alt="profile-image"
                                    loading="lazy" />
                            </div>
                        </div>
                        <div class="profile-info">
                            <h3>Abdul Aziz Halepoto</h3>
                        </div>
                    </div>
                    <div class="sipper">
                        <div class="card-wrapper-data">
                            <div class="profile-wrapper">
                                <img src="assets/images/Board of Directors/Dilbar Samejo.jfif" alt="profile-image"
                                    loading="lazy" />
                            </div>
                        </div>
                        <div class="profile-info">
                            <h3>Dilbar Samejo</h3>
                        </div>
                    </div>
                    <div class="sipper">
                        <div class="card-wrapper-data">
                            <div class="profile-wrapper">
                                <img src="assets/images/Board of Directors/Ghazi Khan.jfif"
                                    alt="profile-image" loading="lazy" />
                            </div>
                        </div>
                        <div class="profile-info">
                            <h3>Ghazi Khan</h3>
                        </div>
                    </div>
                    <div class="sipper">
                        <div class="card-wrapper-data">
                            <div class="profile-wrapper">
                                <img src="assets/images/Board of Directors/Iqbal Rajar.jfif" alt="profile-image"
                                    loading="lazy" />
                            </div>
                        </div>
                        <div class="profile-info">
                            <h3>Iqbal Rajar</h3>
                        </div>
                    </div>
                    <div class="sipper">
                        <div class="card-wrapper-data">
                            <div class="profile-wrapper">
                                <img src="assets/images/Board of Directors/Muhammad Khan Rajar.jfif" alt="profile-image"
                                    loading="lazy" />
                            </div>
                        </div>
                        <div class="profile-info">
                            <h3>Muhammad Khan Rajar</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="team-slider">
            <div class="container">
                <div class="causes-content text-center my-5">
                    <h2 class="section-title">Advisory Board</h2>
                    <p class="section-detail" style="width: 60%; margin: auto;">Our Advisory Board comprises a select
                        group of esteemed advisors who provide invaluable expertise and strategic guidance RDCO. They
                        bring a wealth of knowledge in areas such as WASH, education, health, Disaster Reduction
                        programs etc, offering insights that shape our strategic decisions and enhance our impact. Our
                        advisory board members are committed to supporting our mission and helping us navigate complex
                        challenges effectively</p>
                </div>
                <div class="slider">
                    <div class="sipper">
                        <div class="card-wrapper-data">
                            <div class="profile-wrapper">
                                <img src="assets/images/Advisory Board/Ali Mudasar.jpg" alt="profile-image"
                                    loading="lazy" />
                            </div>
                        </div>
                        <div class="profile-info">
                            <h3>Ali Mudasar</h3>
                        </div>
                    </div>
                    <div class="sipper">
                        <div class="card-wrapper-data">
                            <div class="profile-wrapper">
                                <img src="assets/images/Advisory Board/Khan Muhammad Rajar.JPG" alt="profile-image"
                                    loading="lazy" />
                            </div>
                        </div>
                        <div class="profile-info">
                            <h3>Khan Muhammad Rajar</h3>
                        </div>
                    </div>
                    <div class="sipper">
                        <div class="card-wrapper-data">
                            <div class="profile-wrapper">
                                <img src="assets/images/Advisory Board/Madam Gurya Omer Farooque.jpeg"
                                    alt="profile-image" loading="lazy" />
                            </div>
                        </div>
                        <div class="profile-info">
                            <h3>Madam Gurya Omer Farooque</h3>
                        </div>
                    </div>
                    <div class="sipper">
                        <div class="card-wrapper-data">
                            <div class="profile-wrapper">
                                <img src="assets/images/Advisory Board/Madam Mishal.JPG" alt="profile-image"
                                    loading="lazy" />
                            </div>
                        </div>
                        <div class="profile-info">
                            <h3>Madam Mishal</h3>
                        </div>
                    </div>
                    <div class="sipper">
                        <div class="card-wrapper-data">
                            <div class="profile-wrapper">
                                <img src="assets/images/Advisory Board/Saad Chaudhary.jpg" alt="profile-image"
                                    loading="lazy" />
                            </div>
                        </div>
                        <div class="profile-info">
                            <h3>Saad Chaudhary</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="team-slider intro">
            <div class="container">
                <div class="causes-content text-center my-5">
                    <h2 class="section-title" style="color: #fff;">Our Volunteers Team</h2>
                    <p class="section-detail" style="color: #fff; width: 60%; margin: auto;">Our volunteers are integral to our success, contributing their time, skills, and dedication to support our initiatives and help those in need.
                    </p>
                </div>
                <div class="slider">
                    <div class="sipper">
                        <div class="card-wrapper-data">
                            <div class="profile-wrapper">
                                <img src="assets/images/Board of Directors/Abdul Aziz Halepoto.jfif" alt="profile-image"
                                    loading="lazy" />
                            </div>
                        </div>
                        <div class="profile-info">
                            <h3>Abdul Aziz Halepoto</h3>
                        </div>
                    </div>
                    <div class="sipper">
                        <div class="card-wrapper-data">
                            <div class="profile-wrapper">
                                <img src="assets/images/Board of Directors/Dilbar Samejo.jfif" alt="profile-image"
                                    loading="lazy" />
                            </div>
                        </div>
                        <div class="profile-info">
                            <h3>Dilbar Samejo</h3>
                        </div>
                    </div>
                    <div class="sipper">
                        <div class="card-wrapper-data">
                            <div class="profile-wrapper">
                                <img src="assets/images/Board of Directors/Ghazi Khan.jfif"
                                    alt="profile-image" loading="lazy" />
                            </div>
                        </div>
                        <div class="profile-info">
                            <h3>Ghazi Khan</h3>
                        </div>
                    </div>
                    <div class="sipper">
                        <div class="card-wrapper-data">
                            <div class="profile-wrapper">
                                <img src="assets/images/Board of Directors/Iqbal Rajar.jfif" alt="profile-image"
                                    loading="lazy" />
                            </div>
                        </div>
                        <div class="profile-info">
                            <h3>Iqbal Rajar</h3>
                        </div>
                    </div>
                    <div class="sipper">
                        <div class="card-wrapper-data">
                            <div class="profile-wrapper">
                                <img src="assets/images/Board of Directors/Muhammad Khan Rajar.jfif" alt="profile-image"
                                    loading="lazy" />
                            </div>
                        </div>
                        <div class="profile-info">
                            <h3>Muhammad Khan Rajar</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    

    <!-- FOOTER START -->
    <?php include 'footer.php' ?>

    <!-- FOOTER END -->
    <!-- FOOTER SCRIPTS -->

    <script src="js/jquery.min.js"></script>
    <script src="js/popper.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js"></script>
    <script src="js/owl.carousel.js"></script>
    <script src="js/custom.js"></script>


    <script type="text/javascript">
        $(document).ready(function () {
            $('.slider').slick({
                slidesToShow: 3,
                slidesToScroll: 1,
                autoplay: true,
                autoplaySpeed: 2000,
                dots: true,
                arrows: true,
                prevArrow: '<button type="button" class="slick-prev">Previous</button>',
                nextArrow: '<button type="button" class="slick-next">Next</button>',
                responsive: [
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 1
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1
                        }
                    }
                ]
            });
        });
    </script>


</body>

</html>