<!DOCTYPE html>
<!--[if (gte IE 9)|!(IE)]><!-->
<html lang="en">
<!--<![endif]-->

<head>
    <title>Rozedhani Community Organization</title>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="" />
    <meta name="keywords" content="" />
    <meta name="author" content="" />
    <meta name="title" content="" />
    <link type="image/x-icon" href="assets/images/logo/logo.png" rel="icon">
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800%7CRoboto+Slab:300,400,700"
        rel="stylesheet">
    <link rel="stylesheet" href="css/font-awesome.min.css">
    <link href="css/bootstrap.min.css" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" href="css/danveer.css">
    <link rel="stylesheet" type="text/css" href="css/custam.css">

    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-142494086-2"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag() { dataLayer.push(arguments); }
        gtag('js', new Date());

        gtag('config', 'UA-142494086-2');
    </script>
</head>

<body>
    <!-- START PRELOADER -->
    <div id="preloader">
        <div id="spinner">
            <img src="image/tab-icon.png" alt="loader" class="loading">
            <h5 class="line-height-50 font-18">Loading...</h5>
        </div>
    </div>
    <!-- END PRELOADER -->

    <!-- HEADER START -->
    <?php include 'header.php' ?>

    <!-- HEADER END -->


    <!-- MAIN START -->
    <main class="main">
        <div class="contact-banner text-left">
            <div class="banner-content">
                <div class="container pl-0">
                    <h1 class="heading-three">Donate Us</h1>
                </div>
            </div>
        </div>
    </main>



    <div class="intro text-center">
        <div class="container">
            <div class="row">
                <h1 class="head-one inline">Join Us in Transforming Lives in Achro Thar</h1>
                <span class="intro-span inline">Dear Friends and Supporters</span>
                <p class="detail-p">
                    In the heart of Achro Thar, where communities face daily challenges for clean drinking water,
                    shelter, and basic healthcare, we are committed to making a difference. Our organization is
                    dedicated to providing essential humanitarian aid and fostering sustainable development in this
                    vulnerable region.</p>
            </div>
        </div>
    </div>


    <section>
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="Why-Your-Support py-3">
                        <h3>Why Your Support Matters</h3>
                    </div>
                    <div class="intro-group">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="intro-grp-detail p-3" style="box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);">
                                        <img src="image/help-icon.png" class="mb-2 mb-lg-4" alt="help-icon">
                                        <h2 class="sub-head-two inline">Clean Drinking Water</h2>
                                        <p class="intro-detail-p mb-0">Thousands in Achro Thar lack access to safe
                                            drinking water. Your donation will help us install and maintain clean water
                                            sources, ensuring healthier lives for families.
                                        </p>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="intro-grp-detail p-3" style="box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);">
                                        <img src="image/volunteer-icon.png" class="mb-2 mb-lg-4" alt="volunteer-icon">
                                        <h2 class="sub-head-two inline">Shelter and Food Security</h2>
                                        <p class="intro-detail-p mb-0">: Many families in Achro Thar live in inadequate
                                            shelter and struggle with food insecurity. Your support will provide
                                            shelters and ensure nutritious meals for those in need.
                                        </p>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="intro-grp-detail p-3" style="box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);">
                                        <img src="image/volunteer-icon.png" class="mb-2 mb-lg-4" alt="volunteer-icon">
                                        <h2 class="sub-head-two inline">Emergency Response</h2>
                                        <p class="intro-detail-p mb-0">Achro Thar is prone to emergencies like droughts
                                            and floods. Your contribution will help us set up emergency camps and
                                            deliver immediate relief to affected families.

                                        </p>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="intro-grp-detail p-3" style="box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);">
                                        <img src="image/education-icon.png" class="mb-2 mb-lg-4" alt="education-icon">
                                        <h2 class="sub-head-two inline">Healthcare Services</h2>
                                        <p class="intro-detail-p mb-0">Basic healthcare is a luxury for many. Your
                                            donation will enable us to establish medical camps, provide essential
                                            medicines, and improve health outcomes for the community</p>

                                    </div>
                                </div>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section>
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="Why-Your-Support py-3">
                        <h3>How You Can Help</h3>
                    </div>
                    <div class="intro-group">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="intro-grp-detail p-3" style="box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);">
                                        <img src="image/help-icon.png" class="mb-2 mb-lg-4" alt="help-icon">
                                        <h2 class="sub-head-two inline">Donate Today</h2>
                                        <p class="intro-detail-p mb-0">Every contribution, no matter the size, makes a
                                            meaningful impact on the lives of Achro Thar's residents
                                        </p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="intro-grp-detail p-3" style="box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);">
                                        <img src="image/volunteer-icon.png" class="mb-2 mb-lg-4" alt="volunteer-icon">
                                        <h2 class="sub-head-two inline">Spread the Word</h2>
                                        <p class="intro-detail-p mb-0">Share our cause with your friends, family, and
                                            colleagues. Together, we can raise awareness and mobilize support for those
                                            in need.

                                        </p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="intro-grp-detail p-3" style="box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);">
                                        <img src="image/volunteer-icon.png" class="mb-2 mb-lg-4" alt="volunteer-icon">
                                        <h2 class="sub-head-two inline">Volunteer</h2>
                                        <p class="intro-detail-p mb-0">Join us in the field or lend your skills
                                            remotely. Your time and expertise can make a difference in our efforts</p>
                                    </div>
                                </div>
                                <div class="my-4">
                                    <p class="intro-span inline">
                                        <span></span>
                                    </p>
                                </div>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="intro text-center mt-5">
        <div class="container">
            <div class="row">
                <div class="col-md-7">
                    <span class="intro-span inline">Your generosity will bring hope and create lasting change in Achro
                        Thar. Together, we can transform lives and build a brighter future for these resilient
                        communities. Thank you for considering our appeal and for your compassion towards those in
                        need.</span>
                </div>
                <div class="col-md-5">
                    <div class="bank-account-deatls"
                        style="box-shadow: 0 0 10px rgba(0, 0, 0, 0.1); background-color: #ffff;">
                        <h4>Bank Account Details</h4>
                        <ul>
                            <li>
                                <div class="bank-dtals-for-donation">
                                    <span class="title-span">Title of Account</span>
                                    <span class="deatls-span">Roze Dhani Community Organization</span>
                                </div>
                                <div class="bank-dtals-for-donation">
                                    <span class="title-span">Bank Name</span>
                                    <span class="deatls-span">Muslim Commercial Bank</span>
                                </div>
                                <div class="bank-dtals-for-donation">
                                    <span class="title-span">Branch Name</span>
                                    <span class="deatls-span">Khipro</span>
                                </div>
                                <div class="bank-dtals-for-donation">
                                    <span class="title-span">IBAN No</span>
                                    <span class="deatls-span">PK34 MUCB 0436 3400 8100 0605</span>
                                </div>
                                <div class="bank-dtals-for-donation">
                                    <span class="title-span">Account No</span>
                                    <span class="deatls-span">0436 3400 8100 0605</span>
                                </div>

                            </li>
                        </ul>
                        <h4>Easy Paisa </h4>
                        <ul>
                            <li>
                                <div class="bank-dtals-for-donation">
                                    <span class="title-span">Easy Paisa Account No</span>
                                    <span class="deatls-span">0346 2087571</span>
                                </div>
                            </li>
                        </ul>

                        <h4>Jazz Cash</h4>
                        <ul>
                            <li>
                                <div class="bank-dtals-for-donation">
                                    <span class="title-span">Jazz Cash Account Number</span>
                                    <span class="deatls-span">0300 3329647</span>
                                </div>
                            </li>
                        </ul>

                    </div>
                </div>
            </div>
        </div>
        </div>
        

        <!-- MAIN END -->
       
    <!-- FOOTER START -->
    <?php include 'footer.php' ?>

    <!-- FOOTER END -->
    <!-- FOOTER SCRIPTS -->
    <script src="js/jquery.min.js"></script>
    <script src="js/popper.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/owl.carousel.js"></script>
    <script src="js/custom.js"></script>
</body>

</html>